

<?php $__env->startSection('title', 'Select Server - Store'); ?>

<?php $__env->startSection('content'); ?>
<div class="store-container">
    <div class="container">
        <!-- Store Header -->
        <div class="store-header">
            <h1 class="store-title">Select Your Server</h1>
            <p class="store-subtitle">Choose your preferred server to view available packages and enhance your gaming experience</p>
        </div>

        <!-- Server Selection Section -->
        <div class="server-selection-section">
            <div class="servers-grid">
                <?php $__currentLoopData = $servers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $server): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="server-card" data-server-id="<?php echo e($server->id); ?>">
                    <div class="server-icon">
                        <i class="fas fa-server"></i>
                    </div>
                    <div class="server-info">
                        <h3><?php echo e($server->name); ?></h3>
                        <p><?php echo e($server->description ?? 'Experience premium gameplay with exclusive features and content.'); ?></p>
                        
                        <div class="server-stats">
                            <div class="stat">
                                <i class="fas fa-users"></i>
                                <span><?php echo e($server->player_count ?? 'Active'); ?> Players</span>
                            </div>
                            <div class="stat">
                                <i class="fas fa-box"></i>
                                <span><?php echo e($server->packages()->where('is_active', true)->count()); ?> Packages</span>
                            </div>
                        </div>
                        
                        <?php if($server->is_featured): ?>
                        <div class="server-badge">
                            <i class="fas fa-star"></i>
                            Featured
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="server-actions">
                        <a href="<?php echo e(route('store.index', ['server_id' => $server->id])); ?>" class="btn-select-server">
                            <span>Select Server</span>
                            <i class="fas fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Browse All Option -->
            <div class="browse-all-section">
                <div class="browse-all-card">
                    <div class="browse-all-content">
                        <h3>Browse All Packages</h3>
                        <p>View packages available across all servers without selecting a specific server</p>
                    </div>
                    <a href="<?php echo e(route('store.index', ['server_id' => ''])); ?>" class="btn-browse-all">
                        <span>Browse All</span>
                        <i class="fas fa-globe"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/store/server-selection.blade.php ENDPATH**/ ?>